// logger.middleware.js
export const requestLogger = (req, res, next) => {
  const start = Date.now();

  // Capture the status after response finishes
  res.on("finish", () => {
    const duration = Date.now() - start;
    console.log(`[${req.method}] ${req.originalUrl} -> ${res.statusCode} (${duration}ms)`);
  });

  next();
};
