import mongoose, { Schema } from "mongoose";

const tokenSchema = new Schema(
  {
    tokenType: {
      type: String,
      enum: ["verification", "refresh"],
      required: true
    },
    token: {
      type: String,
      required: true
    },
    otp: {
      type: String
    },
    otpType: {
      type: String,
      enum: ["email", "phone"],
      default: null
    },
    otpExpireAt: {
      type: Date
    },
    isVerified: {
      type: Boolean,
      default: false
    },
    isUsed: {
      type: Boolean,
      default: false
    },
    userId: {
      type: Schema.Types.ObjectId,
      ref: "User",
      required: true
    },
    authId: {
      type: Schema.Types.ObjectId,
      ref: "UserAuth",
      validate: {
        validator: function (value) {
          if (this.tokenType === "refresh" && !value) return false;
          return true;
        },
        message: "authId is required when tokenType is 'refresh'"
      }
    },
    expiresAt: {
      type: Date,
      required: true
    },
    ipAddress: {
      type: String
    },
    userAgent: {
      type: String
    }
  },
  {
    timestamps: true
  }
);

// Indexes
tokenSchema.index({ token: 1 });
tokenSchema.index({ userId: 1 });
tokenSchema.index({ authId: 1 });

export const Token = mongoose.model("Token", tokenSchema);
