import mongoose, {Schema} from "mongoose";
import jwt from "jsonwebtoken";


const userSchema = new Schema(
  {
    fullName: {
      type: String,
      required: true,
      trim: true
    },
    email: {
      type: String,
      required: true,
      unique: true,
      lowercase: true,
      trim: true
    },
    phone: {
      type: String,
      trim: true,
      unique: true,
      sparse: true  // allows null/undefined + unique
    },
    userType: {
      type: String,
      enum: ["planner", "vendor"],
      required: true
    },
    status: {
      type: String,
      enum: ["active", "inactive", "banned"],
      default: "active"
    }
  },
  {
    timestamps: true
  }
);


userSchema.methods.generateAccessToken = function(){
    return jwt.sign(
        {
            _id: this._id,
            email: this.email,
            phone: this.phone,
        },
        process.env.ACCESS_TOKEN_SECRET,
        {
            expiresIn: process.env.ACCESS_TOKEN_EXPIRY
        }
    )
}

userSchema.methods.generateRefreshToken = function(){
    return jwt.sign(
        {
            _id: this._id,
            
        },
        process.env.REFRESH_TOKEN_SECRET,
        {
            expiresIn: process.env.REFRESH_TOKEN_EXPIRY
        }
    )
}

export const User = mongoose.model("User", userSchema)