 import { Token } from "../models/token.model.js"
import { User } from "../models/user.model.js";
import { ApiError } from "./ApiError.js";


// const generateAccessAndRefereshTokens = async (userId) => {
//   try {
//     const user = await User.findById(userId);
//     const accessToken = user.generateAccessToken();
//     const refreshToken = user.generateRefreshToken();

//     await Token.create({
//       tokenType: "refresh",
//       token: refreshToken, 
//       userId,
//       expiresAt: new Date(Date.now() + 7 * 24 * 60 * 60 * 1000), // 7 days
//       isVerified: true,
//       isUsed: false
//     });

//     return {
//       accessToken,
//       refreshToken: refreshToken 
//     };
//   } catch (error) {
//     throw new ApiError(
//       500,
//       "Something went wrong while generating referesh and access token"
//     );
//   }
// };

// const generateAccessAndRefreshTokens = async (userId, existingTokenDoc = null) => {
//   try {
//     const user = await User.findById(userId);
//     const accessToken = user.generateAccessToken();
//     const refreshToken = user.generateRefreshToken();

//     const expiresAt = new Date(Date.now() + 7 * 24 * 60 * 60 * 1000); // 7 days

//     if (existingTokenDoc) {
//       // ✅ Modify existing token doc
//       existingTokenDoc.tokenType = "refresh";
//       existingTokenDoc.otp = null; // Clear OTP if it was a verification token
//       existingTokenDoc.token = refreshToken;
//       existingTokenDoc.expiresAt = expiresAt;
//       existingTokenDoc.isVerified = true;
//       existingTokenDoc.isUsed = false;

//       await existingTokenDoc.save();
//     } else {
//       // 🆕 Create new if no existing one
//       await Token.create({
//         tokenType: "refresh",
//         token: refreshToken,
//         userId,
//         expiresAt,
//         isVerified: true,
//         isUsed: false
//       });
//     }

//     return {
//       accessToken,
//       refreshToken
//     };
//   } catch (error) {
//     throw new ApiError(
//       500,
//       "Something went wrong while generating refresh and access token"
//     );
//   }
// };

const generateAccessAndRefreshTokens = async (userId, existingTokenDoc = null, meta = {}) => {
  try {
    const user = await User.findById(userId);
    if (!user) {
      throw new ApiError(404, "User not found while generating tokens");
    }

    const accessToken = user.generateAccessToken?.();
    const refreshToken = user.generateRefreshToken?.();

    if (!accessToken || !refreshToken) {
      throw new ApiError(500, "Failed to generate access or refresh token");
    }

    const expiresAt = new Date(Date.now() + 7 * 24 * 60 * 60 * 1000); // 7 days

    if (existingTokenDoc) {
      existingTokenDoc.tokenType = "refresh";
      existingTokenDoc.otp = null;
      existingTokenDoc.token = refreshToken;
      existingTokenDoc.expiresAt = expiresAt;
      existingTokenDoc.isVerified = true;
      existingTokenDoc.isUsed = false;

      if (meta.authId) existingTokenDoc.authId = meta.authId;
      if (meta.ipAddress) existingTokenDoc.ipAddress = meta.ipAddress;
      if (meta.userAgent) existingTokenDoc.userAgent = meta.userAgent;

      await existingTokenDoc.save();
    } else {
      await Token.create({
        tokenType: "refresh",
        token: refreshToken,
        userId,
        authId: meta.authId || undefined,
        ipAddress: meta.ipAddress || undefined,
        userAgent: meta.userAgent || undefined,
        expiresAt,
        isVerified: true,
        isUsed: false
      });
    }

    return {
      accessToken,
      refreshToken
    };
  } catch (error) {
    console.error("🔥 Token generation error:", error);
    throw new ApiError(
      500,
      error.message || "Something went wrong while generating refresh and access token"
    );
  }
};




export { generateAccessAndRefreshTokens };